class GooPuff expands UT_SpriteSmokePuff;

#exec TEXTURE IMPORT NAME=PuffSkin FILE=Textures\PuffSkin.bmp group="Skins" LODSET=2

var int numBlobs;
var vector SurfaceNormal;

replication
{
	unreliable if( Role==ROLE_Authority )
		numBlobs, SurfaceNormal;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	SetTimer(0.01, false);
}

simulated function Timer()
{
	Local GooBlob GB;
	local int j;

	if ( (Level.NetMode != NM_DedicatedServer) && (numBlobs > 0) && Level.bHighDetailMode && !Level.bDropDetail )
	{
		numBlobs = FMin(numBlobs, 5);
		for (j=0; j<numBlobs; j++) 
		{
			GB = Spawn(class'GooBlob',,,Location+SurfaceNormal*(FRand()*8-4));
			if (GB != None)
			{
				GB.SetUp(SurfaceNormal);
				GB.RemoteRole = ROLE_None;
			}
		}
	}
}

defaultproperties
{
     numBlobs=3
     //SSprites(0)=Texture'Botpack.GoopEx.g1r_a00'
     //SSprites(1)=Texture'Botpack.GoopEx.g2r_a00'
     //SSprites(2)=Texture'Botpack.GoopEx.g3r_a00'
     SSprites(0)=Texture'PuffSkin'
     SSprites(1)=Texture'PuffSkin'
     SSprites(2)=Texture'PuffSkin'
     SSprites(3)=None
     RisingRate=20.000000
     NumSets=3
     Pause=0.070000
     LifeSpan=1.000000
     //Texture=Texture'Botpack.GoopEx.g1r_a00'
     Texture=Texture'PuffSkin'
     DrawScale=1.400000
}
